package aln.SpawnCommands;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Random;

import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;

public class CommandTeleportAsk implements ICommand {
  
  public static String[] acceptAndDenyWords = new String[] {"accept","deny","allow","disallow","yes","no","ok","all"};
  public static String[] acceptWords = new String[] {"accept","allow","yes","ok"};
  public static String[] taCommandWords = new String[] {"egg"};
  
  public static float responseTimeLimitSeconds;
  public static long  responseTimeLimit;
  public static float requestJustCameInDelaySeconds;
  public static long  requestJustCameInDelay;
  public static float lastPlayerAskedTimeoutHours;
  public static long  lastPlayerAskedTimeout;
  
  private static final String TAConfigBasePath = SpawnCommands.configBasePath+"/_TeleportAsk/";
  public static final String incomingRequestFileName = "_TeleportAsk_IncomingRequest.txt";
  public static final String incomingResponseFileName = "_TeleportAsk_IncomingResponse.txt";
  public static final String genericResponseFileName = "_TeleportAsk_GenericResponse.txt";
  public static final String lastPlayerAskedFileName = "_TeleportAsk_LastPlayerAsked";
  
  @Override
  public int compareTo(Object arg0) {
    return 0;
  }
  
  @Override
  public String getCommandName() {
    return Do.getConfigArrayValue(SpawnCommands.commandNames ,"ta");
  }
  
  @Override
  public String getCommandUsage(ICommandSender sender) { 
    // Apparently this is run EVERY time someone does /help of any kind...
    if (0 == new Random().nextInt(30)) {
      return "/ta notch -Asks notch if you may teleport to him. Then telports you to Sweeden.Ya!";
      //      123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789 12   // limited to 82 characters long lol
    }
    return "/ta help     Displays a page of help for Teleport Ask";
  }
  
  @Override
  public List getCommandAliases() {
    return Arrays.asList(new String[] { });
  }
  
  @Override
  public void processCommand(ICommandSender sender, String[] params) throws CommandException {
    if(sender instanceof EntityPlayer) {
      EntityPlayer player = (EntityPlayer) sender;
      //String playerName = player.getName(); // mc1.8
      String playerName = player.getGameProfile().getName(); // 1.7.10
      
      World world = player.worldObj;
      if ( world.isRemote ) { return; }
      
      // command permissions. "no" is handled by not registering the command at all. "op" and "enable" are handled here. "all" is the default.
      SpawnCommands.loadCommandPermissionsConfig();
      if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "at").equalsIgnoreCase("op") && (! Do.IsOp(player)) ) 
      { Do.Say(player,"Op only command.  You are not an op."); return; }
      if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "at").equalsIgnoreCase("enabled") && (! SpawnCommands.advancedCommandsAreEnabled() ) ) 
      { Do.Say(player,"Advanced spawn commands are not enabled."); return; }
      
      SpawnCommands.loadMiscConfig();
      responseTimeLimitSeconds = Do.getConfigArrayValueFloat(SpawnCommands.miscConfigArray,"teleportask responseTimeLimitSeconds"); // 45s default
      if (responseTimeLimitSeconds < 10) { responseTimeLimitSeconds = 10; } // minimum 10sec
      responseTimeLimit = (long) (responseTimeLimitSeconds * 1000);
      requestJustCameInDelaySeconds = Do.getConfigArrayValueFloat(SpawnCommands.miscConfigArray,"teleportask requestJustCameInDelaySeconds"); // 1.2s default
      requestJustCameInDelay = (long) (requestJustCameInDelaySeconds * 1000);
      lastPlayerAskedTimeoutHours = Do.getConfigArrayValueFloat(SpawnCommands.miscConfigArray,"teleportask lastPlayerAskedTimeoutHours"); // 16h default
      if (lastPlayerAskedTimeoutHours < (10/60)) { lastPlayerAskedTimeoutHours = 10/60; } // minimum 10min
      lastPlayerAskedTimeout = (long) (lastPlayerAskedTimeoutHours * 1000*60*60);
      
      long timeNow = (new Date()).getTime(); // in milliseconds
      String timeNowString = Long.toString(timeNow);
      
      boolean allWord = false; // true if they used the word all as the 2nd parameter such as /ta accept all or /ta deny all
      if ( (params.length > 1) && (params[1] != null) && (params[1].equalsIgnoreCase("all") )) { allWord = true; }
      
      if ((params.length > 0) &&
         (     params[0].equalsIgnoreCase("help") 
          || ( params.length > 2 ) 
          || ((params.length == 2) && (! allWord)) 
         )) { ShowTAHelp(player); return; }
      
      if ( SpawnCommands.isSingleplayer ) 
      { Do.Say(player," ");Do.Say(player,"/§eta§r  (§eT§releport §eA§rsk) is a Multiplayer only feature."); Do.Say(player,"Sorry, there is no need for it in single player mode."); return; }
      String filePathAndName;
      MinecraftServer mcServer = ((EntityPlayerMP)player).mcServer;
      
      // "/ta"  with no parameters 
      if ( params.length == 0 ) {
        String[]  lastPlayerAsked = Do.FileToString(TAConfigBasePath+playerName+"/"+lastPlayerAskedFileName).split(",");
        if (   (  lastPlayerAsked.length > 1) 
            && (! lastPlayerAsked[1].equals(""))
            && ( (timeNow - Long.parseLong(lastPlayerAsked[0])) < lastPlayerAskedTimeout )
           ) {
          // Repeating last ask or last accepted ask
          Do.Say(player,"/"+Do.getConfigArrayValue(SpawnCommands.commandNames,"ta")+" §e"+lastPlayerAsked[1]+"§r");
          params = new String[1];
          params[0] = lastPlayerAsked[1];
          // now continue as if they had typed that name again
        } else 
        { ShowTAHelp(player); return; }
      }
      
      // params.length == 1 or 2
      
      //  /ta accept or /ta deny
      if ( Do.hasItemInArray(params[0].toLowerCase(), acceptAndDenyWords ) ) {
        // /ta accept only
        if ( Do.hasItemInArray(params[0].toLowerCase(), acceptWords ) ) { 
          
          // "/ta accept all"    set my generic answer file with the accept all and the time.
          if (allWord) { 
            if (Do.StringToFile(TAConfigBasePath+playerName+"/"+genericResponseFileName,timeNowString)) { 
              Do.SayToAll(player,"§e"+playerName+"§r is accepting all /ta requests for "+responseTimeLimitSeconds+"s");
              return;
            }
            else 
            { Do.Err(player,"Could not write to file "+TAConfigBasePath+playerName+"/"+genericResponseFileName); return; }
          }
          
          // "/ta accept" a specific incoming request if there is any
          filePathAndName = TAConfigBasePath+playerName+"/"+incomingRequestFileName;
          if (Do.fileExists(filePathAndName)) {
            String[] incomingRequest = Do.FileToString(filePathAndName).split(",");
            if ( incomingRequest.length != 3 ) { Do.Say(player,"You have no pending Teleport Ask request now."); return; } // either there is no request or its an invalid file format
            
            long   requestTime = Long.parseLong(incomingRequest[0]);
            String requestName = incomingRequest[1];
            String requestType = incomingRequest[2]; // currently only using "ta" teleport ask general request.  This is for future features.
            //EntityPlayer requestPlayer = mcServer.getConfigurationManager().getPlayerByUsername(requestName); // mc1.8 // will be null if they are not in game
            EntityPlayer requestPlayer = Do.getPlayerByUsername(mcServer,requestName); // mc1.7.10 custom function // will be null if they are not in game
            
            // safety time delay if a request comes in while answering a request
            if ( (timeNow - requestTime) < requestJustCameInDelay ) {
              Do.Say(player,"A new request just came in.");
              Do.Say(player,"Did §enot§r accept request from "+requestName+".  Try again.");
              return;
            }
            
            if ( requestType.equals("ta") && ((timeNow - requestTime) < responseTimeLimit) ) { // if within time limit
              if (! Do.StringToFile(TAConfigBasePath+requestName+"/"+incomingResponseFileName,""+timeNow+","+playerName+","+"accept") ) 
              { Do.Err(player,"Could not create file "+TAConfigBasePath+requestName+"/"+incomingResponseFileName); return; }
              Do.Say(requestPlayer,"Teleport Ask has been §2accepted§r by "+playerName+". ("+responseTimeLimitSeconds+"s)"); // if requestPlayer is null Do.Say does nothing.
              Do.Say(player,"You have accepted §e"+requestName+"§r asking to teleport to you. ("+responseTimeLimitSeconds+"s)");
              Do.StringToFile(TAConfigBasePath+requestName+"/"+lastPlayerAskedFileName,timeNow+","+playerName); // save the last /ta name for simple /ta to re issue the request
              Do.Say(requestPlayer,"Try /"+Do.getConfigArrayValue(SpawnCommands.commandNames,"ta")+" now.");
              return;
            } else { Do.Say(player,"You have no pending Teleport Ask request now"); return; }
            
          } else { Do.Say(player,"You have no pending Teleport Ask request now"); return; } // 2.1.5
        } else { // else not accept words
          // /ta deny type words
          
          // "/ta deny all"
          if (allWord) {
            String filePathAndNameGenResp = TAConfigBasePath+playerName+"/"+genericResponseFileName;
            if ( Do.fileExists(filePathAndNameGenResp) ) {
              if ( Do.fileDelete(filePathAndNameGenResp) ) {
                Do.Say(player,"Cancelled automatic acceptance of all teleport requests."); // do not return so it can deny any pending request
              } else {
                Do.Err(player,"Could not remove file "+filePathAndNameGenResp); return;
              }
            } else {
              Do.Say(player,"Automatic acceptace of all teleport requests was already cancelled.");
            }
          }
          
          // "/ta deny"
          filePathAndName = TAConfigBasePath+playerName+"/"+incomingRequestFileName;
          if (Do.fileExists(filePathAndName)) { // if there is a pending ta request
            String[] incomingRequest = Do.FileToString(filePathAndName).split(",");
            if ( incomingRequest.length != 3 ) { Do.Say(player,"You have no specific Teleport Ask requests now."); return; } // either there is no request or its an invalid file format
            
            // get request details
            long   requestTime = Long.parseLong(incomingRequest[0]);
            String requestName = incomingRequest[1];
            String requestType = incomingRequest[2]; // currently only using "ta" teleport ask general request.  This is for future features.
            //EntityPlayer requestPlayer = mcServer.getConfigurationManager().getPlayerByUsername(requestName); // mc1.8 // will be null if they are not in game
            EntityPlayer requestPlayer = Do.getPlayerByUsername(mcServer,requestName); // mc1.7.10 custom function // will be null if they are not in game
            
            // safety time delay if a request comes in while answering a request
            if ( (timeNow - requestTime) < requestJustCameInDelay ) {
              Do.Say(player,"A new request just came in.");
              Do.Say(player,"Did §enot§r deny request from "+requestName);
              return;
            }
            
            if ( Do.fileDelete(filePathAndName) ) {
              if ( requestType.equals("ta") && ((timeNow - requestTime) < responseTimeLimit) ) { // if within time limit    Do.Say(player,"Teleport Ask from "+requestName+" is denied.");
                Do.Say(requestPlayer,"Teleport Ask has been §4denied§r by "+playerName+"."); 
                Do.Say(player,"Denied Teleport Ask from "+requestName);
                return;
              } else { Do.Say(player,"You have no specific Teleport Ask requests now"); return; }
            } else {
              Do.Err(player,"Could not remove file "+filePathAndName+"/"+incomingRequestFileName); return;
            }
          } else { Do.Say(player,"You have no specific Teleport Ask requests now"); return; } // 2.1.5
          
        } // end of both /ta accept and /ta deny processing
        // all accept and deny processing should have called a return by now.
      } // end if acceptAndDenyWords
      
      // params[0] should be someone's name or a command
      String theName = params[0];
      theName = Do.correctFromItemInArrayForCase(theName, mcServer.getAllUsernames());
      
      //EntityPlayer destinationPlayer = mcServer.getConfigurationManager().getPlayerByUsername(theName); // mc1.8 // will be null if they are not in game
      EntityPlayer destinationPlayer = Do.getPlayerByUsername(mcServer,theName); // mc1.8 // will be null if they are not in game
      
      // "/ta command"
      if ( Do.hasItemInArray(params[0],taCommandWords) ) {
        if (params[0].equalsIgnoreCase("egg")) { // sample command
          Do.Say(player,"Chicken. Egg. Chicken! Egg! CHICKEN! EGG! Chicken egg? egg.     Ya, an egg.");
          world.playSoundAtEntity(player,"mob.chicken.hurt", 1, 1);
          return;
        }
      } else { // "/ta playername"
        if ( destinationPlayer == null ) { Do.Say(player,"§e"+params[0]+"§r is not a player in game right now."); return; }
        Do.StringToFile(TAConfigBasePath+playerName+"/"+lastPlayerAskedFileName,timeNow+","+theName); // save the last /ta name for simple /ta to re issue the request
        if ( theName.equalsIgnoreCase(playerName) ) { Do.Say(player,"Wow! So cool! It's like you are already here."); return; }
        
        if ( theName != null )  { 
          
          //check if they are generically allowing people to teleport to them, if so then go.
          String genericResponsePathAndFileName = TAConfigBasePath+theName+"/"+genericResponseFileName;
          if ( Do.fileExists(genericResponsePathAndFileName) ) { // they have a generic response
            long genericResponseTime = Long.parseLong(Do.FileToString(genericResponsePathAndFileName));
            if ( (timeNow - genericResponseTime) < responseTimeLimit ) { // within the time limit
              SendPlayerToPlayer(player,destinationPlayer);
              return;
            }
          }
          
          //check if they have responded with accept within the time allowed, if so then go.
          String incomingResponsePathAndFileName = TAConfigBasePath+playerName+"/"+incomingResponseFileName;
          if ( Do.fileExists(incomingResponsePathAndFileName) ) {
            // get response details
            String[] incomingResponse = Do.FileToString(incomingResponsePathAndFileName).split(",");
            long   responseTime = Long.parseLong(incomingResponse[0]);
            String responseName = incomingResponse[1];
            String responseType = incomingResponse[2]; // the accept or deny data value
            
            boolean accepted = ( responseType.equals("accept") );
            EntityPlayer responsePlayer = Do.getPlayerByUsername(mcServer,responseName); // mc1.7.10 custom function // will be null if they are not in game
            
            // if they have accepted
            if (theName.equalsIgnoreCase(responseName)) { // if this is the player we want a response from
              if ( ( accepted ) && ( (timeNow - responseTime) < responseTimeLimit )) { // is accepted within the time limit
                SendPlayerToPlayer(player,responsePlayer);
                return;
              }
            }
          }  
          
          // file the request
          String filePathAndNameInReq = TAConfigBasePath+theName+"/"+incomingRequestFileName; // destination player's incoming request
          if (! Do.StringToFile(filePathAndNameInReq,timeNow+","+playerName+",ta") )
          { Do.Err(player,"Could not write file "+filePathAndNameInReq); return; }
          Do.Say(destinationPlayer,"§e"+playerName+"§r is asking permission to teleport to you.");
          Do.Say(player,"§e"+destinationPlayer.getGameProfile().getName()+"§r has been asked if you may teleport there.");
          return;
        }
      }  // "/ta playername"
    } // end if entity player
  }
  
  public void SendPlayerToPlayer(EntityPlayer fromPlayer, EntityPlayer toPlayer) {
    World fromWorld = fromPlayer.worldObj;
    
    if (toPlayer == null) { Do.Err(fromPlayer,"SendPlayerToPlayer: the toPlayer was null."); return; }
    
    // get player's location at start of this teleport request
    double  px = Math.round(fromPlayer.posX - .5); // player's coordinates rounded down
    double  py = Math.round(fromPlayer.posY - .5);
    double  pz = Math.round(fromPlayer.posZ - .5);
    Float   pyaw = fromPlayer.rotationYaw;
    Float   ppitch = fromPlayer.rotationPitch;
    Integer pdim = fromPlayer.worldObj.provider.dimensionId;
    Integer originDim = pdim;
    String newGoBackLocation = px +","+ py +","+ pz +","+ pyaw +","+ ppitch +","+ pdim;
    
    // get current destination
    px     = Math.round(toPlayer.posX - .5); // player's coordinates rounded down
    py     = Math.round(toPlayer.posY - .5);
    pz     = Math.round(toPlayer.posZ - .5);
    pyaw   = toPlayer.rotationYaw;
    ppitch = toPlayer.rotationPitch;
    pdim   = toPlayer.worldObj.provider.dimensionId;
    Do.Trace("SendPlayerToPlayer dims: "+originDim+","+pdim);
    if ( originDim != pdim ) { // if changing dimensions
      // if in The End and the dragon is alive...
      boolean dragonIsAlive = false;
      if ( originDim == 1 ) { // if in The End ...
        for ( int k = 0; k < fromWorld.loadedEntityList.size(); k++ ) {
          Entity it = (Entity) fromWorld.loadedEntityList.get(k);
          if ( it instanceof EntityDragon ) { 
            dragonIsAlive = true;
            k = fromWorld.loadedEntityList.size();
          }
        }
      } // end dragon check          
      // if trying to go out of The End
      if (( originDim == 1 ) && ( pdim != 1 ) && ( dragonIsAlive ) && (! Do.getConfigArrayValueBoolean(SpawnCommands.miscConfigArray, "AllowToLeaveTheDragon")) ) 
      { Do.Say(fromPlayer,"The mighty dragon is in control of this world. You must defeat the dragon or death is your only escape!"); return; }
      // The following is a hack fix that overcomes a problem when directly leaving the end to any other dimension.
      // The problem: when you leave the end to another dimension the world will NOT load.
      // The solution: when you go to another dimension then go to a third one it WILL load, so we go to another one on the way.
      if ( ( originDim == 1 ) && ( pdim != 1 ) ) {
        if ( pdim == 0 ) { fromPlayer.travelToDimension(-1); } else { fromPlayer.travelToDimension(0); } 
      }
      fromPlayer.travelToDimension(pdim); // officially change dimension now
    } // end if changing dimensions
    
    // write the location of the next go back command
    if (! Do.StringToFile(SpawnCommands.configBasePath+fromPlayer.getGameProfile().getName()+"/_"+fromPlayer.getGameProfile().getName()+"_GoBackLocation", newGoBackLocation ) ) {
      Do.Err(fromPlayer,"Teleport Ask (/ta): Could not create the file that stores the location to go back to.");
      return;
    }
    
    // don't spawn in solid blocks check
    while ( ( py < fromPlayer.worldObj.getActualHeight() ) 
        &&  ( (!SpawnCommands.canSpawnInsideBlock(fromPlayer, px, py, pz)) || (!SpawnCommands.canSpawnInsideBlock(fromPlayer, px, py + 1, pz)) )
          ) 
    { py++; }
    // falling check
    while ( ( py > 1 ) 
        &&  ( (SpawnCommands.canSpawnInsideBlock(fromPlayer, px, py - 1, pz)) && (SpawnCommands.canSpawnInsideBlock(fromPlayer, px, py, pz)) )
          ) 
    { py--; }
    // lava under feet check
    // mc1.8
    //BlockPos posBelowFeet = new BlockPos(px, (py-1), pz);
    //if ((py>1) && ( ( fromPlayer.worldObj.getBlockState(posBelowFeet).getBlock() == Blocks.lava) || ( fromPlayer.worldObj.getBlockState(posBelowFeet).getBlock() == Blocks.flowing_lava) )) {
    //  fromPlayer.worldObj.setBlockState(posBelowFeet, Blocks.cobblestone.getDefaultState());
    //}
    // mc1.7.10
    if ((py>1) && ( ( fromPlayer.worldObj.getBlock((int)px, (int)(py-1), (int)pz) == Blocks.lava) || ( fromPlayer.worldObj.getBlock((int)px, (int)(py-1), (int)pz) == Blocks.flowing_lava) )) {
      fromPlayer.worldObj.setBlock((int)px, (int)(py-1), (int)pz, Blocks.cobblestone);
    }
    
    // actually go there now.
    ((EntityPlayerMP) fromPlayer).playerNetServerHandler.setPlayerLocation(px + .5d, py, pz + .5d, pyaw, ppitch);
    Do.Say(toPlayer,fromPlayer.getGameProfile().getName()+" has teleported to you.");
    return;
  }
  
  public void ShowTAHelp(EntityPlayer player) {
    Do.Say(player," ");
    if ( Do.getConfigArrayValue(SpawnCommands.commandNames,"ta").equalsIgnoreCase("ta") ) {
      Do.Say(player,"§eTA§r means §eT§releport §eA§rsk.");
    }
    if (SpawnCommands.isSingleplayer) { Do.Say(player,"This is for §emultiplayer§r games only."); }
    Do.Say(player,"/"+ Do.getConfigArrayValue(SpawnCommands.commandNames,"ta") +" PlayerName     Asks permission to teleport to a player.");
    Do.Say(player,"       Once your request is accepted then");
    Do.Say(player,"       try again with just /"+ Do.getConfigArrayValue(SpawnCommands.commandNames,"ta") +" to teleport there.");
    Do.Say(player," ");
    Do.Say(player,"/"+ Do.getConfigArrayValue(SpawnCommands.commandNames,"ta") +" yes|accept|ok   Gives that player permission for "+responseTimeLimitSeconds+"s");
    Do.Say(player,"/"+ Do.getConfigArrayValue(SpawnCommands.commandNames,"ta") +" no|deny           Denies requested permission");
    Do.Say(player,"/"+ Do.getConfigArrayValue(SpawnCommands.commandNames,"ta") +" allow|deny §eall§r     Allows or denies all requests for "+responseTimeLimitSeconds+"s");
    Do.Say(player,"/"+ Do.getConfigArrayValue(SpawnCommands.commandNames,"ta") +" help     Displays this quick help page");
    Do.Say(player,"This is a polite way to teleport to other players.");
  }
  
  @Override
  public boolean canCommandSenderUseCommand(ICommandSender icommandsender) {
    return true;
  }

  @Override
  //public List addTabCompletionOptions(ICommandSender sender, String[] args, BlockPos pos) { // mc1.8
  public List addTabCompletionOptions(ICommandSender sender, String[] astring) { // mc1.7.10
    //experiment:  // how does this work in singleplayer worlds? will it crash?
    List<String> list = Arrays.asList(((EntityPlayerMP)sender).mcServer.getConfigurationManager().getAllUsernames());
    return list;
    //return null;
  }

  @Override
  public boolean isUsernameIndex(String[] astring, int i) {
    return false;
  }

}
